<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Address adapter.
 */
class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId()
    {
        return $this->object['addressTypeID'];
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->object['name'];
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->object['firstname'];
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->object['lastname'];
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->object['street'];
    }

    /**
     * @return string|null
     */
    public function getZip()
    {
        if (empty($this->object['zip'])) {
            return null;
        }
        return $this->object['zip'];
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->object['city'];
    }

    /**
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return null;
    }

    /**
     * @return string|null
     */
    public function getEmailAddress()
    {
        return null;
    }

    /**
     * @return string|null
     */
    public function getWebsiteAddress()
    {
        return null;
    }

    /**
     * @return float|null
     */
    public function getLatitude()
    {
        return null;
    }

    /**
     * @return float|null
     */
    public function getLongitude()
    {
        return null;
    }

    public function isLookup(): bool
    {
        return false;
    }
}
