<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Article adapter interface.
 *
 * Defines the interface for all article adapters
 * representing an article.
 */
interface ArticleAdapterInterface extends ObjectAdapterInterface
{
    /**
     * Returns the main type of the article.
     *
     * This is used for filtering records.
     *
     * @see Concern\ArticleConstants
     * @return int
     */
    public function getMainType();

    /**
     * Returns the full name of the article.
     *
     * @return string
     */
    public function getName();

    /**
     * Returns the abstract of the article.
     *
     * @return string
     */
    public function getAbstract();

    /**
     * Returns the description of the article.
     *
     * @return string
     */
    public function getDescription();

    /**
     * @return null|AddressAdapterInterface
     */
    public function getMainAddress();

    /**
     * Returns assigned address records.
     *
     * @return AddressAdapterInterface[]
     */
    public function getAddresses();

    /**
     * Returns assigned category records.
     *
     * @return CategoryAdapterInterface[]
     */
    public function getCategories();

    /**
     * Returns assigned media files.
     *
     * @return MediumAdapterInterface[]
     */
    public function getMedia();

    /**
     * Returns assigned files.
     *
     * @return FileAdapterInterface[]
     */
    public function getFiles();

    /**
     * Checks if attributes exist.
     *
     * @return bool
     */
    public function hasAttributes();

    /**
     * Returns an array of various attributes.
     *
     * @return array<AttributeAdapterInterface>
     */
    public function getAttributes();

    /**
     * Returns the facebook URI.
     *
     * @return string
     */
    public function getFacebookUri();

    /**
     * Returns the twitter URI.
     *
     * @return string
     */
    public function getTwitterUri();

    /**
     * Returns the instagram URI.
     *
     * @return string
     */
    public function getInstagramUri();

    /**
     * Returns the youtube URI.
     *
     * @return string
     */
    public function getYoutubeUri();

    /**
     * Returns the name of the record source.
     *
     * @return string
     */
    public function getSourceName();

    /**
     * Returns the name of the author.
     *
     * @return string
     */
    public function getAuthorName();

    /**
     * Returns the URI for an external booking page.
     *
     * @return string
     */
    public function getBookingUri();

    /**
     * Returns the URI for an external detail page.
     *
     * @return string
     */
    public function getDetailUri();

    /**
     * The complete opening times data.
     *
     * @return string|null
     */
    public function getOpeningTimes();

    /**
     * Return the star classification for hotels.
     *
     * @return int
     */
    public function getStarClassification();

    /**
     * Return the average rating on a scale of 0-100
     *
     * @return int
     */
    public function getAverageRating();

    /**
     * Return the number of ratings.
     *
     * @return int
     */
    public function getNumberOfRatings();
}
