<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\OpeningTimeAdapterInterface;

/**
 * Opening time adapter.
 */
class OpeningTimeAdapter extends AbstractLegacyObjectAdapter implements OpeningTimeAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId()
    {
        return $this->object['id'];
    }

    /**
     * @return int
     */
    public function getType()
    {
        switch ($this->object['type']) {
            case 'opentimesmain':
                return self::TYPE_REGULAR;

            case 'opentimes':
                return self::TYPE_SEASONAL;

            case 'actiontimes':
            case 'closetimes':
                return self::TYPE_SPECIAL;
        }
    }

    /**
     * @return \DateTime|null
     */
    public function getBeginsOn()
    {
        if (array_key_exists('date_from_closed', $this->object)) {
            return \DateTime::createFromFormat('d.m.Y', $this->object['date_from_closed']) ?: null;
        }

        if (array_key_exists('date_range', $this->object)) {
            $parts = explode('-', $this->object['date_range']);
            return \DateTime::createFromFormat('d.m.Y', trim($parts[0])) ?: null;
        }

        return null;
    }

    /**
     * @return \DateTime|null
     */
    public function getEndsOn()
    {
        if (array_key_exists('date_to_closed', $this->object)) {
            return \DateTime::createFromFormat('d.m.Y', $this->object['date_to_closed']) ?: null;
        }

        if (array_key_exists('date_range', $this->object)) {
            $parts = explode('-', $this->object['date_range']);
            return \DateTime::createFromFormat('d.m.Y', trim($parts[1])) ?: null;
        }

        return null;
    }

    /**
     * @return bool
     */
    public function getIsOpen()
    {
        return ($this->object['type'] !== 'closetimes');
    }

    /**
     * @return string|NULL
     */
    public function getOpensAtTime()
    {
        if (array_key_exists('from_time', $this->object)) {
            return $this->object['from_time'];
        }

        return null;
    }

    /**
     * @return string|NULL
     */
    public function getClosesAtTime()
    {
        if (array_key_exists('to_time', $this->object)) {
            return $this->object['to_time'];
        }

        return null;
    }

    /**
     * @return bool
     */
    public function getMonday()
    {
        if ($this->object['type'] === 'closetimes') {
            // Closetimes affect all days.
            return true;
        }
        return ($this->object['weekday'] === 'Montag');
    }

    /**
     * @return bool
     */
    public function getTuesday()
    {
        if ($this->object['type'] === 'closetimes') {
            // Closetimes affect all days.
            return true;
        }
        return ($this->object['weekday'] === 'Dienstag');
    }

    /**
     * @return bool
     */
    public function getWednesday()
    {
        if ($this->object['type'] === 'closetimes') {
            // Closetimes affect all days.
            return true;
        }
        return ($this->object['weekday'] === 'Mittwoch');
    }

    /**
     * @return bool
     */
    public function getThursday()
    {
        if ($this->object['type'] === 'closetimes') {
            // Closetimes affect all days.
            return true;
        }
        return ($this->object['weekday'] === 'Donnerstag');
    }

    /**
     * @return bool
     */
    public function getFriday()
    {
        if ($this->object['type'] === 'closetimes') {
            // Closetimes affect all days.
            return true;
        }
        return ($this->object['weekday'] === 'Freitag');
    }

    /**
     * @return bool
     */
    public function getSaturday()
    {
        if ($this->object['type'] === 'closetimes') {
            // Closetimes affect all days.
            return true;
        }
        return ($this->object['weekday'] === 'Samstag');
    }

    /**
     * @return bool
     */
    public function getSunday()
    {
        if ($this->object['type'] === 'closetimes') {
            // Closetimes affect all days.
            return true;
        }
        return ($this->object['weekday'] === 'Sonntag');
    }

    /**
     * @return string
     */
    public function getNote()
    {
        return $this->object['description'];
    }
}
