<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\AbstractService;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService\PointOfInterestAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\OpeningTimeAdapter;

/**
 * Service for legacy Toubiz DB API.
 */
class DbService extends AbstractService
{
    /**
     * @var string Base URI of API endpoint.
     */
    const BASE_URI = 'https://db-service.toubiz.de/';

    /**
     * @var array Object definition for this service.
     */
    const OBJECTS = [
        'Article' => PointOfInterestAdapter::class,
    ];

    /**
     * Fetch records.
     *
     * @param callable $block
     * @return void
     */
    public function fetchPointOfInterests(callable $block)
    {
        $offset = 0;
        $limit = 10;
        while (true) {
            $data = $this->sendRequest($offset, $limit);
            if (!$data) {
                return;
            }

            foreach ($data as $item) {
                $article = new PointOfInterestAdapter($item);
                $block($article);
            }

            $offset += $limit;
        }
    }

    /**
     * Send request to endpoint.
     *
     * This combines request parameters with required
     * authentication parameters and checks the response.
     *
     * @param int $offset
     * @param int $limit
     * @return mixed
     */
    protected function sendRequest($offset, $limit)
    {
        $parameters = [
            ':apiKey' => $this->apiKey,
            ':clientName' => $this->clientName,
            ':offset' => $offset,
            ':limit' => $limit
        ];

        $url = str_replace(
            array_keys($parameters),
            array_values($parameters),
            '/layout/set/json/content/view/json/:clientName/' .
            '(key)/:apiKey/(class)/attraction/(modified)/864000000/(offset)/:offset/(limit)/:limit'
        );

        $response = $this->httpClient->request('GET', $url);
        if ($response->getStatusCode() == 200) {
            $data = json_decode($response->getBody(), true);
            if ($data['content']
                && count($data['content']['children_list']) > 0
            ) {
                return $data['content']['children_list'];
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * Fetch opening times for current client.
     *
     * Unfortunately, description translations are returned on
     * different endpoints.
     *
     * @return array<OpeningTimeAdapter>
     */
    public function fetchOpeningTimes()
    {
        $response = $this->httpClient->request(
            'GET',
            'layout/set/json/content/view/jsonline/4841/(key)/'
            . $this->apiKey
            . '/(mandant)/'
            . $this->clientName
        );

        if ($response->getStatusCode() == 200) {
            $content = json_decode($response->getBody(), true);
            $data = $content['content']['object']['data_map'];
            $collection = [];

            /*
             * - "opentimesmain" are usual opening times
             * - "opentimes" are special opening times
             * - "closetimes" are definitions for "closed"
             * - "actiontimes" are special day definitions, like holidays
             */
            foreach (['opentimesmain', 'opentimes', 'closetimes', 'actiontimes'] as $type) {
                if (!is_array($data[$type]['content'])) {
                    continue;
                }

                /*
                 * Due to the difference between interface and received data,
                 * data needs to be split up into different items in order to
                 * be able to use the expected adapter.
                 *
                 * Also, "opentimes" has an additional nesting compared to
                 * the other types.
                 */
                if ($type == 'opentimes') {
                    foreach ($data[$type]['content'] as $dateRange => $items) {
                        foreach ($items as $key => $item) {
                            // The type is obviously missing now.
                            $item['type'] = $type;

                            // The date range is also missing.
                            $item['date_range'] = $dateRange;

                            // There is no identification given on records.
                            $item['id'] = md5($type . $dateRange . $key);

                            $collection[] = new OpeningTimeAdapter($item);
                        }
                    }
                } else {
                    foreach ($data[$type]['content'] as $key => $item) {
                        // The type is obviously missing now.
                        $item['type'] = $type;

                        // There is no identification given on records.
                        $item['id'] = md5($type . $key);

                        $collection[] = new OpeningTimeAdapter($item);
                    }
                }
            }
            return $collection;
        }
    }
}
