<?php
namespace Newland\Toubiz\Api\Service\Outdooractive;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\AbstractService;
use Newland\Toubiz\Api\Service\Outdooractive\ObjectAdapter\TourAdapter;

/**
 * Service for Outdooractive API.
 */
class ApiService extends AbstractService
{
    /**
     * @var string Base URI of API endpoint.
     */
    const BASE_URI = 'https://www.outdooractive.com/api/project/';

    /**
     * @var string Path for fetching the tours list.
     */
    const PATH_TOURS_LIST = ':clientName/tours?key=:apiKey&lang=de';

    /**
     * @var string Path for a tour.
     */
    const PATH_TOUR = ':clientName/oois/:id?key=:apiKey&lang=de';

    /**
     * Fetches tours.
     *
     * @return mixed
     */
    public function fetchTours()
    {
        $tours = [];
        $ids = $this->fetchTourList();
        foreach ($ids as $id) {
            $uri = $this->prepareUri(self::PATH_TOUR, [ ':id' => $id ]);

            // TODO refactor into method
            $response = $this->httpClient->request('GET', $uri);
            if ($response->getStatusCode() === 200) {
                $data = simplexml_load_string($response->getBody());
                $tours[] = new TourAdapter($data);
            } else {
                return false;
            }
        }
        return $tours;
    }

    /**
     * Fetches list of tour ids for importing.
     *
     * @return array
     */
    protected function fetchTourList()
    {
        $uri = $this->prepareUri(self::PATH_TOURS_LIST);

        // TODO refactor into method – isn't there one in abstract?
        $response = $this->httpClient->request('GET', $uri);
        if ($response->getStatusCode() === 200) {
            $data = simplexml_load_string($response->getBody());
            if (!$data) {
                return [];
            }

            $ids = [];
            foreach ($data as $entry) {
                $ids[] = (int) $entry['id'];
            }

            return $ids;
        }
        return [];
    }

    protected function prepareUri($uri, $parameters = [])
    {
        $parameters = array_merge(
            $parameters,
            [
                ':apiKey' => $this->apiKey,
                ':clientName' => $this->clientName,
            ]
        );

        return str_replace(
            array_keys($parameters),
            $parameters,
            $uri
        );
    }
}
