<?php
namespace Newland\Toubiz\Api\Service\OpenWeatherMap;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\AbstractService;
use Newland\Toubiz\Api\Service\OpenWeatherMap\ObjectAdapter\WeatherAdapter;

class ApiService extends AbstractService
{
    const BASE_URI = 'http://api.openweathermap.org/data/2.5/forecast';

    /**
     * @var array
     */
    private $forecast = [];
    /**
     * @var bool
     */
    private $debug = false;

    public function fetchForecast(): array
    {
        foreach ($this->parameters['locations'] as $locationName => $coordinates) {
            $weatherData = $this->getForecastForLocation($coordinates);
            $this->forecast[$locationName] = new WeatherAdapter($locationName, $weatherData);
        }

        return $this->forecast;
    }

    private function getForecastForLocation(array $coordinatas)
    {
        if ($this->debug) {
            return $this->getDummyData();
        } else {
            return $this->getDataFromApi($coordinatas);
        }
    }

    private function getDataFromApi(array $coordinatas): array
    {
        $response = $this->httpClient->get(self::BASE_URI, [
            'query' => [
                'lat' => $coordinatas['lat'],
                'lon' => $coordinatas['lon'],
                'apiKey' => $this->apiKey,
                'units' => 'metric',
            ],
        ]);

        return json_decode($response->getBody(), true);
    }

    private function getDummyData()
    {
        $json = (string) file_get_contents(
            __DIR__ . '/../../../Tests/Fixtures/WeatherData/openWeatherMap.json'
        );

        return json_decode($json, true);
    }
}
