<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Concern\OpeningTimeConstants;

/**
 * Opening time adapter interface.
 *
 * Defines the interface for opening time adapters
 * representing opening times from Toubiz.
 */
interface OpeningTimeAdapterInterface extends ObjectAdapterInterface, OpeningTimeConstants
{
    /**
     * Returns the type for this opening time.
     *
     * @return int
     */
    public function getType();

    /**
     * Returns the date when this records starts its validity,
     * or NULL if it is always valid.
     *
     * @return \DateTime|NULL
     */
    public function getBeginsOn();

    /**
     * Returns the date when this records ends its validity,
     * or NULL if it is always valid.
     *
     * @return \DateTime|NULL
     */
    public function getEndsOn();

    /**
     * Returns the open/close state.
     *
     * @return bool
     */
    public function getIsOpen();

    /**
     * Returns the time it opens.
     *
     * @return string|NULL Formatted as "hh:mm"
     */
    public function getOpensAtTime();

    /**
     * Returns the time it closes.
     *
     * @return string|NULL Formatted as "hh:mm"
     */
    public function getClosesAtTime();

    /**
     * Returns if it counts for mondays.
     *
     * @return bool
     */
    public function getMonday();

    /**
     * Returns if it counts for tuesdays.
     *
     * @return bool
     */
    public function getTuesday();

    /**
     * Returns if it counts for wednesdays.
     *
     * @return bool
     */
    public function getWednesday();

    /**
     * Returns if it counts for thursdays.
     *
     * @return bool
     */
    public function getThursday();

    /**
     * Returns if it counts for fridays.
     *
     * @return bool
     */
    public function getFriday();

    /**
     * Returns if it counts for saturdays.
     *
     * @return bool
     */
    public function getSaturday();

    /**
     * Returns if it counts for sundays.
     *
     * @return bool
     */
    public function getSunday();

    /**
     * Returns an optional note.
     *
     * @return string
     */
    public function getNote();
}
