<?php
namespace Newland\Toubiz\Api\ObjectAdapter\Concern;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Opening time constants.
 *
 * Constants for opening times, used in interfaces and implementations.
 */
interface OpeningTimeConstants
{
    /**
     * Type for regular opening times.
     *
     * @var int
     */
    const TYPE_REGULAR = 0;

    /**
     * Type for seasonal opening times, overruling regular ones.
     *
     * @var int
     */
    const TYPE_SEASONAL = 1;

    /**
     * Type for special opening times, overruling regular and seasonal ones.
     *
     * @var int
     */
    const TYPE_SPECIAL = 2;
}
