# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [unreleased]
### Added
- Ability to parse redirect URIs as generated by the brochure module of legacy toubiz.

## [1.6.0] - 2019-04-02
### Added
- Address adapters can now signal that part of their data (e.g. zip-code) should be
  looked up from an external data source (e.g. google).
- The following new tour attributes are now fetched:
    - `directions`
    - `parking`
    - `additionalInformation`
- Additional Information for SnowReports can now be fetched from the API.
- APIServices can now specify a custom `baseUri` as constructor argument.

### Fixed
- Some Adapters incorrectly returned `null`. These returns have either been removed or
  explicitly annotated.
- Only direct marketers marked with `online=1` are now imported from legacy toubiz.
- Calls to Toubiz legacy Event API are now paginated to prevent running into memory issues
  or timeouts.
- TPortal Lodging requests are now retried up to 5 times if they fail in order to cope
  with random failures in TPortal.

### Changed
- Article Adapters now do not have address data themselves, but expose a main address via
  the `getMainAddress` method.
- APIServices are now logger aware: A PSR Logger interface can be passed to them using the
  `setLogger` method.

## [1.5.0] - 2019-03-08
### Added
- New fields are now being imported for outdooractive tours:
    - labels (`top`, `publicTransportFriendly`, ...)
- Media elements from outdooractive are now aware of their sorting