<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\LegacyToubizAddressAdapterCommon;

class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    public function getExternalId(): string
    {
        // There is not really an id for this.
        return strip_tags((string) $this->object['object']['id']);
    }

    public function getTitle(): ?string
    {
        $title = $this->object['object']['data_map']['address_title']['content'];
        return $title ? strip_tags($title) : null;
    }

    public function getFirstName(): ?string
    {
        return null;
    }

    public function getLastName(): ?string
    {
        return null;
    }

    public function getStreet(): ?string
    {
        $value = $this->object['object']['data_map']['street']['content'] ?? null;
        return $value ? strip_tags((string) $value) : null;
    }

    public function getZip(): ?string
    {
        $value = $this->object['object']['data_map']['zip']['content'] ?? null;
        return $value ? strip_tags((string) $value) : null;
    }

    public function getCity(): ?string
    {
        $value = $this->object['city'] ?? null;
        if ($value) {
            return strip_tags((string) $value);
        }

        $value = $this->object['object']['data_map']['city']['content'] ?? null;
        if (!empty($value)) {
            return strip_tags((string) $value);
        }

        return null;
    }

    public function getCountry(): ?string
    {
        return null;
    }

    public function getPhoneNumber(): ?string
    {
        $phoneNumber = $this->object['object']['data_map']['phone']['content'] ?? null;
        return $phoneNumber ? strip_tags((string) $phoneNumber) : null;
    }

    public function getFaxNumber(): ?string
    {
        $faxNumber = $this->object['object']['data_map']['fax']['content'] ?? null;
        return $faxNumber ? strip_tags((string) $faxNumber) : null;
    }

    public function getEmailAddress(): ?string
    {
        $mail = $this->object['object']['data_map']['email']['content'] ?? null;
        return $mail ? strip_tags((string) $mail) : null;
    }

    public function getWebsiteAddress(): ?string
    {
        $url = $this->object['object']['data_map']['url']['content'] ?? null;
        $url = $url ? strip_tags((string) $url) : null;

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if ($url === null || \strlen($url) <= 8) {
            return null;
        }

        // The protocol may also be missing.
        if (strpos($url, 'http') !== 0) {
            $url = 'http://' . $url;
        }

        return $url;
    }

    public function getLatitude(): ?float
    {
        $latitude = $this->object['object']['data_map']['geodata']['content']['latitude'] ?? null;
        return $latitude ? ((float) $latitude) : null;
    }

    public function getLongitude(): ?float
    {
        $longitude = $this->object['object']['data_map']['geodata']['content']['longitude'] ?? null;
        return $longitude ? ((float) $longitude) : null;
    }

    public function isLookup(): bool
    {
        return true;
    }
}
