<?php declare(strict_types=1);


namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\Utility\UrlUtility;

trait MediaCommon
{

    /**
     * TODO support multiple images
     * @return MediumAdapterInterface[]
     */
    public function getMedia(): array
    {
        $item = $this->getPreviewImageItem();
        if ($item) {
            $adapter = new MediumAdapter($item);
            if (UrlUtility::isValidUrl($adapter->getSourceUri())) {
                return [ $adapter ];
            }
        }

        $fallbackUrl = UrlUtility::forceHttps(
            $this->object['package']['previewImageURL']
            ?? $this->object['offer']['previewImageURL']
            ?? $this->object['guide']['previewImageURL']
            ?? null
        );
        if ($fallbackUrl) {
            return [ new MediumAdapter([ 'ID' => $this->getExternalId() . '-main', 'url' => $fallbackUrl ]) ];
        }

        return [];
    }

    public function getPreviewImageItem(): ?array
    {
        foreach ($this->object['serviceData']['multimediaURLs'] ?? [] as $mediaItem) {
            $type = $mediaItem['type']['value'] ?? null;
            $url = $mediaItem['url'] ?? '';

            if ($type === 'Preview' && UrlUtility::isValidUrl($url)) {
                $mediaItem['url'] = UrlUtility::forceHttps($url);
                return $mediaItem;
            }
        }

        return null;
    }
}
