<?php
namespace Newland\Toubiz\Api\Tests\Unit\Service\Meteotest\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\Weather\DayAdapterInterface;
use Newland\Toubiz\Api\Service\Meteotest\ObjectAdapter\WeatherAdapter;
use PHPUnit\Framework\TestCase;

class WeatherAdapterTest extends MeteoTestAdapterTestCase
{

    /**
     * @dataProvider provideSimpleReturnData
     */
    public function testSimpleReturns(string $payloadName, string $getterName, $expectedReturn)
    {
        $this->assertEquals(
            $expectedReturn,
            $this->weatherAdapter($payloadName)->{$getterName}()
        );
    }

    /**
     * @dataProvider provideAllLocationNames
     */
    public function testReturnsArrayOfDayAdapters(string $locationName)
    {
        $days = $this->weatherAdapter($locationName)->getForecast();
        foreach ($days as $day) {
            $this->assertInstanceOf(DayAdapterInterface::class, $day);
        }
    }

    /**
     * @dataProvider provideAllLocationNames
     */
    public function testLastUpdatedShouldAlwaysReturnCurrentTimeStamp(string $locationName)
    {
        $current = time();
        $lastUpdated = $this->weatherAdapter($locationName)->getLastUpdated();
        $this->assertGreaterThan($current - 3, $lastUpdated);
        $this->assertLessThan($current + 3, $lastUpdated);
    }

    public function provideSimpleReturnData(): array
    {
        return [
            [ 'Andermatt', 'getLocation', 'Andermatt' ],
            [ 'Realp', 'getLocation', 'Realp' ],
            [ 'Hospental', 'getLocation', 'Hospental' ],
            [ 'Gurtnellen', 'getLocation', 'Gurtnellen' ],
            [ 'Göschenen', 'getLocation', 'Göschenen' ],
        ];
    }
}
