<?php declare(strict_types=1);


namespace Newland\ToubizApi\Tests\Unit\Utility;


use Newland\Toubiz\Api\Utility\UrlUtility;
use PHPUnit\Framework\TestCase;

class UrlUtilityTest extends TestCase
{

    /** @dataProvider provideUrls */
    public function testUrlValidity(string $url, bool $isValid) {
        $this->assertEquals($isValid, UrlUtility::isValidUrl($url));
    }

    public function provideUrls(): array {
        return [
            'empty string' => [ '', false ],
            'only http' => [ 'http://', false ],
            'only https' => [ 'https://', false ],
            'arbitrary string 1' => [ 'foo:bar//', false ],
            'arbitrary string 2' => [ 'Bazz quux', false ],
            'valid' => [ 'https://land-in-sicht.de', true ],
        ];
    }
}
