<?php
namespace Newland\ToubizApi\Tests\Unit\Utility;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Tests\UnitTestCase;
use Newland\Toubiz\Api\Utility\UrlUtility;

class UrlConverterTest extends UnitTestCase
{
    /**
     * @param string $expected
     * @param string $originalUrl
     *
     * @dataProvider getForceHttpsProtocolExamples
     */
    public function testForceHttpsProtocol(?string $expected, ?string $originalUrl): void
    {
        $this->assertEquals($expected, UrlUtility::forceHttps($originalUrl));
    }

    public function getForceHttpsProtocolExamples(): array
    {
        return [
            [ 'https://foo.bar', 'http://foo.bar' ],
            [ 'https://foo.bar', 'https://foo.bar' ],
            [ null, null ],
            [ 'https://foo.bar?http=true', 'http://foo.bar?http=true' ],
            [ 'asset://foo.bar', 'asset://foo.bar' ],
        ];
    }
}
