<?php declare(strict_types=1);


namespace Newland\ToubizApi\Tests\Unit\Utility;


use Newland\Toubiz\Api\Utility\StringUtility;
use PHPUnit\Framework\TestCase;

class StringUtilityTest extends TestCase
{

    public function testShouldReplaceGivenReplacements(): void
    {
        $this->assertEquals(
            'Here comes Johannes... There he was',
            StringUtility::simpleTemplate('Here comes {name}... There he was', [ 'name' => 'Johannes' ])
        );
        $this->assertEquals(
            'Will the real Slim Shady please stand up',
            StringUtility::simpleTemplate(
                'Will the real {firstName} {lastName} please stand up',
                [ 'firstName' => 'Slim', 'lastName' => 'Shady' ]
            )
        );
    }

    public function testShouldReplaceMultipleOcurrences(): void
    {
        $this->assertEquals(
            'yo yo yo',
            StringUtility::simpleTemplate('{foo} {foo} {foo}', [ 'foo' => 'yo' ])
        );
    }

    public function testShouldAllowForCustomEnclosureTags(): void
    {
        $this->assertEquals(
            'Once upon a time',
            StringUtility::simpleTemplate(
                'Once upon <what>',
                [ 'what' => 'a time' ],
                [ '<', '>' ]
            )
        );
    }

    public function testShouldIgnoreNonGivenReplacements(): void
    {
        $this->assertEquals(
            'Test {bar} Yo',
            StringUtility::simpleTemplate(
                '{foo} {bar} {baz}',
                [ 'foo' => 'Test', 'baz' => 'Yo' ]
            )
        );
    }

}