<?php declare(strict_types=1);

namespace Newland\ToubizApi\Tests\Unit\Utility;

use Newland\Toubiz\Api\Utility\AttributeImportUtility;
use PHPUnit\Framework\TestCase;

class AttributeImportUtilityTest extends TestCase
{

    /**
     * @dataProvider callsDataProvider
     * @param array $input
     * @param array $expected
     */
    public function testCallsCallbackWithSplittedData(array $input, array $expected): void
    {
        $calls = [];
        AttributeImportUtility::splitAttributeArrayIntoImportables(
            $input,
            function($name, $value) use (&$calls) {
                $calls[] = [ $name, $value ];
            }
        );
        $this->assertEquals($expected, $calls);
    }

    /**
     * @dataProvider callsDataProvider
     * @param array $input
     * @param array $expected
     */
    public function testCallbackReturnValueIsCollected(array $input, array $expected): void
    {
        $output = AttributeImportUtility::splitAttributeArrayIntoImportables($input, function($name, $value) {
            return [ $name, $value ];
        });
        $this->assertEquals($expected, $output);
    }

    /**
     * @dataProvider callsDataProvider
     * @param array $input
     */
    public function testEmptyCallbackReturnValuesAreIgnored(array $input): void
    {
        $output = AttributeImportUtility::splitAttributeArrayIntoImportables($input, function($name, $value) {
            // Empty return
            return null;
        });
        $this->assertEquals($output, []);
    }

    public function callsDataProvider(): array
    {
        return [
            [
                // Input
                [
                    'foo' => 'bar',
                    'bar' => 1,
                    'baz' => null,
                ],
                // Calls
                [
                    [ 'foo', 'bar'],
                    [ 'bar', 1 ],
                ]
            ],
            [
                // Input
                [
                    'arr' => [ 'foo', 'bar', 'baz' ],
                    'arr2' => [ ['way', 'to'], 'complex' ],
                ],
                // Calls
                [
                    [ 'arr', 'foo' ],
                    [ 'arr', 'bar' ],
                    [ 'arr', 'baz' ],
                    [ 'arr2', [ ['way', 'to'], 'complex' ] ],
                ],
            ]
        ];
    }

}