<?php
namespace Newland\Toubiz\Api\Tests\Unit\Service\Toubiz\Legacy\Brochure\Parser;

use Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure\Parser\UriPathBracketBasedParser;
use PHPUnit\Framework\TestCase;

class UriPathBracketBasedParserTest extends TestCase
{

    /**
     * @dataProvider getData
     * @param string $path
     * @param array $expected
     */
    public function testParsesPaths(string $path, array $expected)
    {
        $this->assertEquals(
            $expected,
            (new UriPathBracketBasedParser())->parse($path)
        );
    }

    public function getData(): array
    {
        return [
            [ '/(foo)/bar/(baz)/test', [ 'foo' => 'bar', 'baz' => 'test' ] ],
            [ '/(foo)/bar/something-else/(baz)/test', [ 'foo' => 'bar', 'baz' => 'test' ] ],
        ];
    }
}
