<?php
namespace Newland\Toubiz\Api\Tests\Unit\Service\Toubiz\Legacy\Brochure\Parser;

use Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure\Parser\SimpleKeyValueParser;
use PHPUnit\Framework\TestCase;

class SimpleKeyValueParserTest extends TestCase
{

    /**
     * @dataProvider getData
     * @param string $input
     * @param string $keySeparator
     * @param string $elementSeparator
     * @param array $expected
     */
    public function testParsesStrings(string $input, string $keySeparator, string $elementSeparator, array $expected)
    {
        $this->assertEquals(
            $expected,
            (new SimpleKeyValueParser($elementSeparator, $keySeparator))->parse($input)
        );
    }

    public function getData(): array
    {
        return [
            [ 'foo!bar,baz!test', '!', ',', [ 'foo' => 'bar', 'baz' => 'test' ] ],
            [ 'foo-bar_baz-test', '-', '_', [ 'foo' => 'bar', 'baz' => 'test' ] ]
        ];
    }
}
