<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

trait StarRatingCommon
{
    public function getStarRatings(): array
    {
        $starRatingMap = $this->object['star_ratings_map'] ?? null;
        $starAttributes = [];
        $rawAttributes = $this->object['housedata']['out']['dataClassAttributeValues'] ?? [];

        foreach ($rawAttributes as $attribute) {
            if (($attribute['twsDataClassAttribute']['name'] ?? null) === 'ClassificationServiceProvider' &&
                ($attribute['twsLookupValues']['externalID'] ?? null) !== null) {
                if ($starRatingMap) {
                    $attributeWithRatingsMap = array_merge($attribute, [
                        'ratings_map' => $starRatingMap,
                    ]);
                    array_push($starAttributes, $attributeWithRatingsMap);
                } else {
                    array_push($starAttributes, $attribute);
                }
            }
        }

        return array_map(
            function (array $attribute) {
                return new StarRatingAdapter($attribute);
            },
            $starAttributes
        );
    }
}
