<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    public function getStreet(): ?string
    {
        $street = $this->object['housedata']['out']['address']['street'] ?? null;
        return $street ? strip_tags($street) : null;
    }

    public function getZip(): ?string
    {
        $zip = $this->object['housedata']['out']['address']['zipCode'] ?? null;
        return $zip ? strip_tags($zip) : null;
    }

    public function getCity(): ?string
    {
        $city = $this->object['housedata']['out']['address']['city'] ?? null;
        return $city ? strip_tags($city) : null;
    }

    public function getCountry(): ?string
    {
        $country = $this->object['housedata']['out']['address']['country']['name'] ?? null;
        return $country ? strip_tags($country) : null;
    }

    public function getLatitude(): ?float
    {
        $latitude = $this->object['housedata']['out']['address']['gmapsLatitude'] ?? null;
        return $latitude ? ((float) $latitude) : null;
    }

    public function getLongitude(): ?float
    {
        $longitude = $this->object['housedata']['out']['address']['gmapsLongitude'] ?? null;
        return $longitude ? ((float) $longitude) : null;
    }

    public function isLookup(): bool
    {
        return true;
    }

    public function getExternalId(): string
    {
        return strip_tags('main_address_' . $this->object['housedata']['out']['ID']);
    }

    public function getTitle(): ?string
    {
        $title = $this->object['name'] ?? null;
        return $title ? strip_tags($title) : null;
    }

    public function getFirstName(): ?string
    {
        $firstName = $this->object['housedata']['out']['address']['personFirstName'] ?? null;
        return $firstName ? strip_tags($firstName) : null;
    }

    public function getLastName(): ?string
    {
        $lastName = $this->object['housedata']['out']['address']['personLastName'] ?? null;
        return $lastName ? strip_tags($lastName) : null;
    }

    public function getPhoneNumber(): ?string
    {
        return '';
    }

    public function getFaxNumber(): ?string
    {
        return '';
    }

    public function getEmailAddress(): ?string
    {
        return '';
    }

    public function getWebsiteAddress(): ?string
    {
        return '';
    }
}
