<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\Legacy;

use GuzzleHttp\Promise\PromiseInterface;
use GuzzleHttp\Psr7\Uri;
use Newland\Toubiz\Api\Guzzle\ConcurrentPaginatedRequests;
use Newland\Toubiz\Api\Service\AbstractService;
use Newland\Toubiz\Api\Service\LanguageAware;
use Newland\Toubiz\Api\Service\ServiceResult;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService\CategoryMap;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\TourApiService\TourAdapter;
use Psr\Log\LoggerAwareTrait;

class TourApiService extends AbstractService
{
    use LanguageAware,
        LoggerAwareTrait,
        SharedLegacyToubizServiceBehaviour;

    public const DEFAULT_BASE_URI = 'https://db-service.toubiz.de/';

    /** @var CategoryMap */
    protected $categoryMap;

    public function fetchTours(\Closure $block): ServiceResult
    {
        $resultPromise = $this->fetchListOfAllExistingObjectsAsServiceResult('tour');

        $concurrency = $this->parameters['concurrency'] ?? 10;
        $pool = new ConcurrentPaginatedRequests($concurrency, function (int $page) use ($block) {
            return $this->requestPage($page)->then(function (array $data) use ($block) {
                foreach ($data['children_list'] as $child) {
                    $block($this->tourDataToAdapter($child), $data['children_count'] ?? 0);
                }
            });
        });


        $pool->start()->wait(true);
        return $resultPromise->wait();
    }

    protected function tourDataToAdapter(array $child): TourAdapter
    {
        if ($this->categoryMap === null) {
            $this->categoryMap = $this->getCategoryMap();
        }

        $adapter = new TourAdapter($child);
        $adapter->setCategoryMap($this->categoryMap);
        $adapter->setLogger($this->logger);
        if ($this->language) {
            $adapter->setLanguage($this->language);
        }
        return $adapter;
    }

    protected function requestPage(int $page, int $pageSize = 25): PromiseInterface
    {
        $url = $this->buildUrl([
               'class' => 'tour',
               'modified' => '864000000',
               'offset' => ($page - 1) * $pageSize,
               'limit' => $pageSize
           ]);

        return $this->jsonRequest(new Uri($url), 5, function (array $data) {
            return !empty($data['content']['children_list']);
        })->then(function (array $data) {
            return $data['content'];
        });
    }
}
