<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\MediumConstants;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractLegacyObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['id_image']);
    }

    public function getSourceUri(): string
    {
        $uri = $this->object['imageURL'] ?? $this->object['imageURLsmall'] ?? '';

        if ($uri === '') {
            return '';
        }

        return strip_tags($uri);
    }

    public function getCopyright(): ?string
    {
        return null;
    }

    public function getTitle(): ?string
    {
        $title = $this->object['description'][0]['text'] ?? null;
        return $title ? strip_tags((string) $title) : null;
    }

    public function getType(): string
    {
        return MediumConstants::TYPE_IMAGE;
    }

    public function getAltText(): ?string
    {
        return null;
    }

    public function getDescription(): ?string
    {
        return null;
    }

    public function getFocusPointX(): ?int
    {
        return null;
    }

    public function getFocusPointY(): ?int
    {
        return null;
    }
}
