<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\KitchenTimeAdapterInterface;

class KitchenTimeAdapter extends AbstractObjectAdapter implements KitchenTimeAdapterInterface
{
    /** @var int */
    private $sorting;

    /** @var array */
    private $originalIdPrefix;

    public function __construct($adaptee, int $sorting, array $originalIdPrefix)
    {
        parent::__construct($adaptee);
        $this->sorting = $sorting;
        $this->originalIdPrefix = $originalIdPrefix;
    }


    public function getFrom(): ?\DateTime
    {
        return $this->dateTimeFromTime((string) $this->object['from']);
    }

    public function getTo(): ?\DateTime
    {
        return $this->dateTimeFromTime((string) $this->object['to']);
    }

    public function getComment(): string
    {
        return (string) ($this->object['comment'] ?? '');
    }

    public function getSorting(): int
    {
        return $this->sorting;
    }

    public function isEmpty(): bool
    {
        return $this->getFrom() === null
            && $this->getTo() === null
            && empty(trim($this->getComment()));
    }

    /**
     * @inheritDoc
     */
    public function getExternalId(): string
    {
        $prefix = implode('__', $this->originalIdPrefix);
        return sprintf('%s__%d', $prefix, $this->sorting);
    }

    private function dateTimeFromTime(string $time): ?\DateTime
    {
        $dateTime = \DateTime::createFromFormat('H:i:s', $time);
        if (!$dateTime || $dateTime->format('H:i') === '00:00') {
            return null;
        }
        return $dateTime->setDate(0, 1, 1);
    }
}
