<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\AttributeAdapterInterface;

class AttributeAdapter extends AbstractObjectAdapter implements AttributeAdapterInterface
{
    /**
     * @param mixed $data
     */
    public function __construct(string $articleExternalId, string $name, $data = null)
    {
        parent::__construct([
            'articleExternalId' => $articleExternalId,
            'name' => $name,
            'data' => $data,
        ]);
    }

    public function getName(): string
    {
        return strip_tags((string) $this->object['name']);
    }

    public function getData()
    {
        return $this->object['data'];
    }

    public function getGroupId()
    {
        return $this->getGroupIdFromName();
    }

    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['articleExternalId']);
    }

    protected function getGroupIdFromName(): string
    {
        return 'default';
    }
}
