<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\LegacyToubizAddressAdapterCommon;

/**
 * Address adapter.
 *
 * This one is specifically for the tportal gastro endpoint.
 */
class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{

    /**
     * @return string
     */
    public function getExternalId(): string
    {
        // There is not really an id for this.
        return strip_tags((string) $this->object['remote_id']);
    }

    public function getTitle(): ?string
    {
        $title = $this->object['address']['name'] ?? null;
        $title = $title ?: $this->object['address']['Title'] ?? null;
        return $title ? strip_tags((string) $title) : null;
    }

    public function getFirstName(): ?string
    {
        $firstName = $this->object['address']['firstname'] ?? null;
        return $firstName ? strip_tags((string) $firstName) : null;
    }

    public function getLastName(): ?string
    {
        $lastName = $this->object['address']['lastname'] ?? null;
        return $lastName ? strip_tags((string) $lastName) : null;
    }

    public function getStreet(): ?string
    {
        $street = $this->object['address']['street'] ?? null;
        return $street ? strip_tags((string) $street) : null;
    }

    public function getZip(): ?string
    {
        $value = $this->object['address']['zip'] ?? null;
        if (!empty($value)) {
            return strip_tags((string) $value);
        }

        return null;
    }

    public function getCity(): ?string
    {
        $city = $this->object['address']['city'] ?? null;
        return $city ? strip_tags((string) $city) : null;
    }

    public function getCountry(): ?string
    {
        return null;
    }

    public function getPhoneNumber(): ?string
    {
        $phoneNumber = $this->object['address']['phone1'] ?? null;
        return $phoneNumber ? strip_tags((string) $phoneNumber) : null;
    }

    public function getFaxNumber(): ?string
    {
        $faxNumber = $this->object['address']['fax'] ?? null;
        return $faxNumber ? strip_tags((string) $faxNumber) : null;
    }

    public function getEmailAddress(): ?string
    {
        $email = $this->object['address']['email'] ?? null;
        return $email ? strip_tags((string) $email) : null;
    }

    public function getWebsiteAddress(): ?string
    {
        $url = $this->object['address']['internet'] ?? null;
        $url = $url ? strip_tags((string) $url) : null;

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if ($url === null || \strlen($url) <= 8) {
            return '';
        }

        // The protocol may also be missing.
        if (strpos($url, 'http') !== 0) {
            $url = 'http://' . $url;
        }

        return $url;
    }

    public function getLatitude(): ?float
    {
        $latitude = $this->object['location']['Latitude'] ?? null;
        return $latitude ? ((float) $latitude) : null;
    }

    public function getLongitude(): ?float
    {
        $longitude = $this->object['location']['Longitude'] ?? null;
        return $longitude ? ((float) $longitude) : null;
    }

    public function isLookup(): bool
    {
        return false;
    }
}
