<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService\EventDate;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\EventDateAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Utility\StringUtility;

/**
 * Event date adapter.
 */
class RceDateAdapter extends EventDateAdapter
{

    public function getDetailUri(): ?string
    {
        if ($this->detailUriTemplate === null) {
            return null;
        }

        if (empty($this->object['id_event_extern']) || empty($this->object['id_date_extern'])) {
            return null;
        }

        return StringUtility::simpleTemplate($this->detailUriTemplate, [
            'rceEventId' => $this->object['id_event_extern'],
            'rceDateId' => $this->object['id_date_extern']
        ]);
    }
}
