<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\LegacyToubizAddressAdapterCommon;

/**
 * Address adapter.
 */
class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    /** @var string|null */
    protected $nameFallback;

    public function __construct($adaptee = null, string $nameFallback = null)
    {
        parent::__construct($adaptee);
        $this->nameFallback = $nameFallback;
    }


    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['addressTypeID']);
    }

    public function getTitle(): ?string
    {
        $title = $this->object['name'] ?? null;
        return $title ? strip_tags((string) $title) : $this->nameFallback;
    }

    public function getFirstName(): ?string
    {
        $firstName = $this->object['firstname'] ?? null;
        return $firstName ? strip_tags((string) $firstName) : null;
    }

    public function getLastName(): ?string
    {
        $lastName = $this->object['lastname'] ?? null;
        return $lastName ? strip_tags((string) $lastName) : null;
    }

    public function getStreet(): ?string
    {
        $street = $this->object['street'] ?? null;
        return $street ? strip_tags((string) $street) : null;
    }

    public function getZip(): ?string
    {
        $zip = $this->object['zip'] ?? null;
        return $zip ? strip_tags((string) $zip) : null;
    }

    public function getCity(): ?string
    {
        $city = $this->object['city'] ?? null;
        return $city ? strip_tags((string) $city) : null;
    }

    public function getCountry(): ?string
    {
        return null;
    }

    public function getPhoneNumber(): ?string
    {
        return null;
    }

    public function getFaxNumber(): ?string
    {
        return null;
    }

    public function getEmailAddress(): ?string
    {
        return null;
    }

    public function getWebsiteAddress(): ?string
    {
        return null;
    }

    public function getLatitude(): ?float
    {
        return null;
    }

    public function getLongitude(): ?float
    {
        return null;
    }

    public function isLookup(): bool
    {
        return false;
    }
}
