<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService;

use Newland\Toubiz\Api\ObjectAdapter\UriAdapterInterface;

class UriAdapter implements UriAdapterInterface
{

    /** @var string */
    protected $externalId;

    /** @var string|null */
    protected $label;

    /** @var string */
    protected $uri;

    public function __construct(string $externalId, ?string $label, string $uri)
    {
        $this->externalId = $externalId;
        $this->label = $label;
        $this->uri = $uri;
    }

    public function getExternalId(): string
    {
        return $this->externalId;
    }

    public function getLabel(): ?string
    {
        return $this->label;
    }

    public function getUri(): string
    {
        return $this->uri;
    }
}
