<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\LegacyToubizAddressAdapterCommon;

class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId(): string
    {
        // There is not really an id for this.
        return strip_tags((string) $this->object['object']['id']);
    }

    public function getTitle(): ?string
    {
        $title = $this->object['object']['data_map']['address_title']['content'] ?? null;
        return $title ? strip_tags((string) $title) : null;
    }

    public function getFirstName(): ?string
    {
        return null;
    }

    public function getLastName(): ?string
    {
        return null;
    }

    public function getStreet(): ?string
    {
        $street = $this->object['object']['data_map']['street']['content'] ?? null;
        return $street ? strip_tags((string) $street) : null;
    }

    public function getZip(): ?string
    {
        $zip = $this->object['object']['data_map']['zip']['content'] ?? null;
        return $zip ? strip_tags((string) $zip) : null;
    }

    public function getCity(): ?string
    {
        $city = $this->object['object']['data_map']['city']['content']
            ?? $this->object['city']
            ?? null;
        return $city ? strip_tags((string) $city) : null;
    }

    public function getCountry(): ?string
    {
        return null;
    }

    public function getPhoneNumber(): ?string
    {
        $phoneNumber = $this->object['object']['data_map']['phone']['content'] ?? null;
        return $phoneNumber ? strip_tags((string) $phoneNumber) : null;
    }

    public function getFaxNumber(): ?string
    {
        $faxNumber = $this->object['object']['data_map']['fax']['content'] ?? null;
        return $faxNumber ? strip_tags((string) $faxNumber) : null;
    }

    public function getEmailAddress(): ?string
    {
        $mail = $this->object['object']['data_map']['email']['content'] ?? null;
        return $mail ? strip_tags((string) $mail) : null;
    }

    public function getWebsiteAddress(): ?string
    {
        $url = $this->object['object']['data_map']['url']['content'] ?? null;
        $url = $url ? strip_tags((string) $url) : null;

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if ($url === null || \strlen($url) <= 8) {
            return null;
        }

        // The protocol may also be missing.
        if (strpos($url, 'http') !== 0) {
            $url = 'http://' . $url;
        }

        return $url;
    }

    public function getLatitude(): ?float
    {
        if (strpos($this->object['geo'], '#') !== false) {
            [$latitude] = explode('#', $this->object['geo']);
            return ((float) $latitude) ?: null;
        }

        return null;
    }

    public function getLongitude(): ?float
    {
        if (strpos($this->object['geo'], '#') !== false) {
            [, $longitude] = explode('#', $this->object['geo']);
            return ((float) $longitude) ?: null;
        }
        return null;
    }

    public function isLookup(): bool
    {
        return true;
    }
}
