<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure\Parser;

/**
 * Parses deeply nested properties where one key may contain the available keys
 * and another property contains the key/value mapping.
 *
 * A parser with nesting key suffix set to '_pros', element separator set to '|' and a key separator
 * set to '-' is able to parse the following array:
 * [
 *      'foo' => 'bar-baz',
 *      'foo_pros' => 'bar|val1-baz|val2'
 * ]
 *
 * into this array:
 * [
 *      'foo' => [
 *          'bar' => 'val1',
 *          'baz' => 'val2'
 *      ]
 * ]
 */
class DeepNestedPropertyParser
{

    /** @var string */
    private $nestingKeySuffix;

    /** @var string */
    private $elementSeparator;

    /** @var string */
    private $keySeparator;

    public function __construct(string $nestingKeySuffix, string $elementSeparator, string $keySeparator)
    {
        $this->nestingKeySuffix = $nestingKeySuffix;
        $this->elementSeparator = $elementSeparator;
        $this->keySeparator = $keySeparator;
    }


    public function parse(array $properties): array
    {
        $deepNestedKeys = [];

        foreach ($properties as $key => $values) {
            $potentialNestingKey = $key . $this->nestingKeySuffix;
            if (array_key_exists($potentialNestingKey, $properties)) {
                $deepNestedKeys[$key] = $potentialNestingKey;
            }
        }

        foreach ($deepNestedKeys as $key => $nestingKey) {
            $keyValuePairs = explode($this->elementSeparator, $properties[$nestingKey]);
            if ($keyValuePairs === false) {
                continue;
            }

            $properties[$key] = [];
            foreach ($keyValuePairs as $pair) {
                list($deepKey, $value) = explode($this->keySeparator, $pair, 2);
                $properties[$key][$deepKey] = $value;
            }

            unset($properties[$nestingKey]);
        }

        return $properties;
    }
}
