<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure;

use Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure\Parser\DeepNestedPropertyParser;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure\Parser\SimpleKeyValueParser;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure\Parser\UriPathBracketBasedParser;

class BrochureRedirectUriConverter
{
    const STATUS_OK = 'ok';
    const VALUE_MARKED = 'mark';

    public function convert(string $uri): BrochureResult
    {
        $uri = urldecode($uri);
        $values = (new UriPathBracketBasedParser())->parse($uri);

        $errors = $this->errorsParser()->parse($values['errors'] ?? '');
        $errors = $this->interpretSpecificValuesAsBoolean($errors, [ static::VALUE_MARKED ], []);

        $requestRaw = $this->requestParser()->parse($values['request'] ?? '');
        $request = $this->deepRequestParser()->parse($requestRaw);

        $success = empty($errors) && ($values['status'] ?? 'failure') === static::STATUS_OK;
        return new BrochureResult($success, $request, $errors);
    }

    private function errorsParser(): SimpleKeyValueParser
    {
        return new SimpleKeyValueParser(',', '!');
    }

    private function requestParser(): SimpleKeyValueParser
    {
        return new SimpleKeyValueParser('!', ',');
    }

    private function deepRequestParser(): DeepNestedPropertyParser
    {
        return new DeepNestedPropertyParser('_pros', '-', '|');
    }

    private function interpretSpecificValuesAsBoolean(array $input, array $treatAsTrue, array $treatAsFalse): array
    {
        return array_map(
            function ($value) use ($treatAsTrue, $treatAsFalse) {
                if (\in_array($value, $treatAsTrue, true)) {
                    return true;
                }
                if (\in_array($value, $treatAsFalse, true)) {
                    return false;
                }
                return $value;
            },
            $input
        );
    }
}
