<?php declare(strict_types=1);

/*
 * Copyright (c) 2022, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV2;

use Newland\Toubiz\Api\ObjectAdapter\ArticleAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\ApiV1\ArticleService as ArticleV1Service;
use Newland\Toubiz\Api\Service\Toubiz\ApiV2\ObjectAdapter\ArticleAdapter;

class ArticleService extends ArticleV1Service
{
    /** @var string */
    protected $detailUriPath = 'api/v2/article';
    /** @var string */
    protected $listUriPath = 'api/v2/articles/minimal';

    protected function getDetailQueryParams(): array
    {
        return [
            'language' => $this->language,
            'api_token' => $this->apiKey,
        ];
    }

    protected function getListRequestParams(): array
    {
        return [
            'api_token' => $this->apiKey,
            'language' => $this->language,
        ];
    }

    protected function makeAdapter(array $data): ArticleAdapterInterface
    {
        return new ArticleAdapter($data, $this->parameters['type']);
    }
}
