<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\KitchenTimeAdapterInterface;

class KitchenTimeAdapter extends AbstractObjectAdapter implements KitchenTimeAdapterInterface
{
    public const FROM = '1daff31d-57b9-4368-bae1-c4fa76106227';
    public const TO = 'e0877abd-b620-4a38-bea8-7ae59d874829';
    public const COMMENT = 'e5d08efa-5c12-42cd-80e2-e0d40d4ba393';

    /** @var int */
    private $replication;

    /** @var array */
    private $externalId;

    public function __construct($adaptee, int $replication, array $externalId)
    {
        parent::__construct($adaptee);
        $this->replication = $replication;
        $this->externalId = $externalId;
    }


    public function getFrom(): ?\DateTime
    {
        return $this->dateTimeFromTime($this->object[self::FROM][$this->replication]['value']['text'] ?? null);
    }

    public function getTo(): ?\DateTime
    {
        return $this->dateTimeFromTime($this->object[self::TO][$this->replication]['value']['text'] ?? null);
    }

    public function getComment(): string
    {
        return $this->object[self::COMMENT][$this->replication]['value']['text'] ?? '';
    }

    public function getSorting(): int
    {
        return $this->replication;
    }

    public function getExternalId(): string
    {
        return implode('__', $this->externalId);
    }

    public function isEmpty(): bool
    {
        return $this->getFrom() === null
            && $this->getTo() === null
            && empty(trim($this->getComment()));
    }

    private function dateTimeFromTime(?string $time): ?\DateTime
    {
        if (!$time) {
            return null;
        }

        // Normalize time string to HH:MM even if it contains seconds.
        $time = preg_replace('/(\d\d):(\d\d).*/', '\1:\2', $time);

        $dateTime = \DateTime::createFromFormat('H:i', $time);
        if (!$dateTime || $dateTime->format('H:i') === '00:00') {
            return null;
        }
        return $dateTime->setDate(0, 1, 1);
    }
}
