<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

trait HasMarketingPrice
{
    public function getMarketingPricePrefix(array $priceInformation): ?string
    {
        return $priceInformation['marketingPricePrefix'] ?? null;
    }

    public function getMarketingPriceValue(array $priceInformation): ?float
    {
        $preferredCurrency = $this->object['channelContext']['currency'] ?? 'EUR';
        $index = $this->getPreferredMarketingPriceIndex($priceInformation, $preferredCurrency);
        $price = $priceInformation['marketingPrices'][$index]['price'] ?? null;

        if ($price === null) {
            return null;
        }

        return (float) $price;
    }

    public function getMarketingPriceCurrency(array $priceInformation): ?string
    {
        $preferredCurrency = $this->object['channelContext']['currency'] ?? 'EUR';
        $index = $this->getPreferredMarketingPriceIndex($priceInformation, $preferredCurrency);

        return $priceInformation['marketingPrices'][$index]['currency'] ?? null;
    }

    public function getMarketingPriceComment(array $priceInformation): ?string
    {
        return $priceInformation['marketingPriceComment'] ?? null;
    }

    private function getPreferredMarketingPriceIndex(array $priceInformation, string $preferredCurrency): int
    {
        $count = count($priceInformation['marketingPrices'] ?? []);

        for ($i = 0; $i < $count; $i++) {
            if (strtoupper($priceInformation['marketingPrices'][$i]['currency']) ===
                strtoupper($preferredCurrency)) {
                return $i;
            }
        }

        return 0;
    }
}
