<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\FileAdapterInterface;

class FileAdapter extends AbstractObjectAdapter implements FileAdapterInterface
{

    /** @var string|null */
    protected $name;

    public function __construct($adaptee = null, string $name = null)
    {
        parent::__construct($adaptee);
        $this->name = $name;
    }


    public function getName()
    {
        if ($this->name) {
            return $this->name;
        }

        $name = $this->object['name'];
        if (!empty($name)) {
            return $name;
        }

        $parts = explode('/', $this->getSourceUri());
        return array_pop($parts);
    }

    public function getSourceUri()
    {
        return $this->object['url'];
    }

    public function getExternalId(): string
    {
        return $this->object['id'];
    }
}
