<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use DateTime;

trait EventCommon
{

    /**
     * Converts date and time strings into a DateTime object.
     *
     * @param string|null $date A date in YYYY-MM-DD format
     * @param string $time A time in hh:mm:ss format
     * @return DateTime|null
     */
    protected function buildDateTimeFromStrings($date, $time = ''): ?DateTime
    {
        if (!$date) {
            return null;
        }

        $object = new DateTime($date);
        if ($time) {
            $exploded = explode(':', $time);
            $hour = $exploded[0];
            $minute = $exploded[1] ?? 0;
            $second = $exploded[2] ?? 0;
            $object->setTime((int) $hour, (int) $minute, (int) $second);
        }
        return $object;
    }
}
