<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AttributeAdapterInterface;

class AttributeAdapter implements AttributeAdapterInterface
{

    /** @var string */
    protected $name;

    /** @var mixed */
    protected $data;

    /** @var string */
    protected $groupId;

    /** @var string */
    protected $externalId;

    /** @param mixed $data */
    public function __construct(string $name, $data, ?string $groupId, string $externalId)
    {
        $this->name = $name;
        $this->data = $data;
        $this->groupId = $groupId;
        $this->externalId = $externalId;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getData()
    {
        return $this->data;
    }

    public function getGroupId()
    {
        return $this->groupId;
    }

    public function getExternalId(): string
    {
        return $this->externalId;
    }
}
