<?php
namespace Newland\Toubiz\Api\Service;

/**
 * Result of a service call.
 * A service can either provide a list of all entity identifiers in the API
 * or a list of identifiers of deleted entities depending on how the API
 * endpoint is structured.
 */
class ServiceResult
{
    /** @var bool */
    private $success = false;

    /** @var string[]|null */
    private $deleted = null;

    /** @var string[]|null */
    private $all = null;

    /** @return string[]|null */
    public function getDeleted(): ?array
    {
        return $this->deleted;
    }

    /** @param string[] $deleted */
    public function setDeleted(array $deleted): void
    {
        $this->deleted = $deleted;
    }

    /** @param string[] $deleted */
    public function addDeleted(array $deleted): void
    {
        $this->deleted = array_merge($this->deleted ?? [], $deleted);
    }

    /** @return string[]|null */
    public function getAll(): ?array
    {
        return $this->all;
    }

    /** @param string[] $all */
    public function setAll(array $all): void
    {
        $this->all = $all;
    }

    public function isSuccess(): bool
    {
        return $this->success;
    }

    public function setSuccess(bool $success): void
    {
        $this->success = $success;
    }
}
