<?php
namespace Newland\Toubiz\Api\Service\OpenWeatherMap\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Weather\DayAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\WeatherAdapterInterface;

class WeatherAdapter implements WeatherAdapterInterface
{
    /**
     * @var string
     */
    private $location;
    /**
     * @var DayAdapter[]
     */
    private $days;
    /**
     * @var int
     */
    private $lastUpdated;

    public function __construct(string $location, array $data)
    {
        $this->location = $location;
        $this->parseData($data);
        $this->lastUpdated = $this->getCurrentTime();
    }

    private function parseData(array $data): void
    {
        $dateToPopulate = '';
        $hourRecordsOfCurrentDay = [];

        foreach ($data['list'] as $hourItem) {
            $itemDate = \DateTime::createFromFormat('U', $hourItem['dt']);
            if (!$dateToPopulate && $itemDate) {
                $dateToPopulate = $itemDate->format('Ymd');
            }

            if ($itemDate && $dateToPopulate === $itemDate->format('Ymd')) {
                $hourRecordsOfCurrentDay[$hourItem['dt']] = $hourItem;
            } else {
                $this->days[] = new DayAdapter($hourRecordsOfCurrentDay);
                $dateToPopulate = '';
                $hourRecordsOfCurrentDay = [
                    $hourItem['dt'] => $hourItem,
                ];
            }
        }
    }

    /**
     * Wrap in public function for mocking.
     *
     * @return int
     */
    public function getCurrentTime(): int
    {
        return time();
    }

    /**
     * Returns the external id used by the API
     * to identify the record.
     *
     * @return string
     */
    public function getExternalId(): string
    {
        return '';
    }

    public function getLocation(): string
    {
        return $this->location;
    }

    /**
     * @return DayAdapterInterface[]
     */
    public function getForecast(): array
    {
        return $this->days;
    }

    /**
     * @return int Timestamp of latest import
     */
    public function getLastUpdated(): int
    {
        return $this->lastUpdated;
    }
}
