<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Weather\DayAdapterInterface;

/**
 * Weather adapter interface.
 *
 * Defines the interface for weather adapters
 * representing a 7 day forecast.
 */
interface WeatherAdapterInterface extends ObjectAdapterInterface
{
    public function getLocation(): string;

    /**
     * @return DayAdapterInterface[]
     */
    public function getForecast(): array;

    /**
     * @return int Timestamp of latest import
     */
    public function getLastUpdated(): int;
}
