<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\ObjectAdapter;

/**
 * Default implementation for this adapter since there will probably not be a lot
 * of variations.
 */
class ExternalIdAdapter implements ExternalIdAdapterInterface
{
    /** @var string */
    private $type;

    /** @var string */
    private $id;

    public function __construct(string $type, string $id)
    {
        $this->type = $type;
        $this->id = $id;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getId(): string
    {
        return $this->id;
    }
}
