<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Address adapter interface.
 *
 * Defines the interface for all address adapters
 * representing an address record attached to another record.
 */
interface AddressAdapterInterface extends ObjectAdapterInterface
{
    public function getTitle(): ?string;

    public function getFirstName(): ?string;

    public function getLastName(): ?string;

    public function getStreet(): ?string;

    public function getZip(): ?string;

    public function getCity(): ?string;

    public function getCountry(): ?string;

    public function getPhoneNumber(): ?string;

    public function getFaxNumber(): ?string;

    public function getEmailAddress(): ?string;

    public function getWebsiteAddress(): ?string;

    public function getLatitude(): ?float;

    public function getLongitude(): ?float;

    /**
     * Lookups are automatically calculated addresses based on coordinates, rather than manual data.
     *
     * @return bool
     */
    public function isLookup(): bool;
}
