<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\StringCleaner;

/**
 * Abstract object adapter.
 */
abstract class AbstractObjectAdapter implements ProvidesRawJson
{
    /** @var mixed Adapted object */
    protected $object;

    /** @var StringCleaner */
    protected $stringCleaner;

    /**
     * AbstractObjectAdapter constructor.
     *
     * @param mixed $adaptee
     * @return void
     */
    public function __construct($adaptee = null)
    {
        $this->setObject($adaptee);
        $this->stringCleaner = new StringCleaner();
    }

    /**
     * @param mixed $adaptee
     * @return void
     */
    public function setObject($adaptee)
    {
        $this->object = $adaptee;
    }

    public function getRawJson(): array
    {
        return (array) $this->object;
    }

    /**
     * @param string|int|bool|array|null $default
     * @return mixed
     */
    public function get(string $path, $default = null)
    {
        $array = $this->object;
        if (!is_array($array)) {
            return $default;
        }

        if (array_key_exists($path, $array)) {
            return $array[$path];
        }

        if (strpos($path, '.') === false) {
            return $array[$path] ?? $default;
        }

        foreach (explode('.', $path) as $segment) {
            if (is_array($array) && array_key_exists($segment, $array)) {
                $array = $array[$segment];
            } else {
                return $default;
            }
        }

        return $array;
    }
}
