<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

trait HasMarketingPrice
{
    public function getMarketingPricePrefix(): ?string
    {
        return $this->object['price']['marketingPricePrefix'] ?? null;
    }

    public function getMarketingPriceValue(): ?float
    {
        $preferredCurrency = $this->object['channelContext']['currency'] ?? 'EUR';
        $index = $this->getPreferredMarketingPriceIndex($preferredCurrency);
        $price = $this->object['price']['marketingPrices'][$index]['price'] ?? null;

        if ($price === null) {
            return null;
        }

        return (float) $price;
    }

    public function getMarketingPriceCurrency(): ?string
    {
        $preferredCurrency = $this->object['channelContext']['currency'] ?? 'EUR';
        $index = $this->getPreferredMarketingPriceIndex($preferredCurrency);

        return $this->object['price']['marketingPrices'][$index]['currency'] ?? null;
    }

    public function getMarketingPriceComment(): ?string
    {
        return $this->object['price']['marketingPriceComment'] ?? null;
    }

    private function getPreferredMarketingPriceIndex(string $preferredCurrency): int
    {
        $count = count($this->object['price']['marketingPrices'] ?? []);

        for ($i = 0; $i < $count; $i++) {
            if (strtoupper($this->object['price']['marketingPrices'][$i]['currency']) ===
                strtoupper($preferredCurrency)) {
                return $i;
            }
        }

        return 0;
    }
}
