<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use DateTimeInterface;
use Newland\Toubiz\Api\Constants\EventScope;

/**
 * Event adapter interface.
 *
 * Defines the interface for all event adapters
 * representing an event record from Toubiz.
 */
interface EventAdapterInterface extends ObjectAdapterInterface
{
    public const DATA_SOURCE_TOUBIZ_APIV1 = 'toubiz_apiv1';
    public const DATA_SOURCE_TOUBIZ_LEGACY = 'toubiz_legacy';

    public function getDataSource(): string;

    public function getEventType(): string;

    public function getName(): string;

    public function getDescription(): string;

    public function getAdditionalInformation(): string;

    public function getBeginsAt(): ?DateTimeInterface;

    public function getEndsAt(): ?DateTimeInterface;

    public function getAdmission(): string;

    public function getIsHighlight(): bool;

    public function getIsTipp(): bool;

    public function getTicketUri(): ?string;

    /**
     * Returns the contact options for buying a ticket.
     *
     * @return string|null
     */
    public function getTicketContact(): ?string;

    public function getLink(): ?string;

    public function getUpdatedAt(): DateTimeInterface;

    /** @return CategoryAdapterInterface[] */
    public function getCategories(): array;

    /** @return EventDateAdapterInterface[] */
    public function getEventDates(): array;

    /** @return EventTagAdapterInterface[] */
    public function getEventTags(): array;

    public function getAttributes(): array;

    /** @return MediumAdapterInterface[] */
    public function getMedia(): array;

    public function getOrganizer(): ?AddressAdapterInterface;

    public function getLocation(): ?AddressAdapterInterface;

    public function getAreaName(): ?string;

    public function getSourceName(): ?string;

    /**
     * Return the scope of the event.
     * Should return a value in the `EventScope` enum
     *
     * @see EventScope
     */
    public function getScope(): int;

    /**
     * Returns the record language of the event as one of the Langauge::* constants
     * or `null` if the record is not translatable.
     */
    public function getLanguage(): ?string;

    public function getAdditionalSearchString(): ?string;

    public function getIsCanceled(): bool;

    public function getCanonicalUrl(): ?string;
}
