<?php declare(strict_types=1);

/*
 * Copyright (c) 2024, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\SeoInformationAdapterInterface;

class SeoInformationAdapter extends AbstractObjectAdapter implements
    SeoInformationAdapterInterface
{
    public function getMetaTitle(): ?string
    {
        return $this->object['metaTitle'] ?? null;
    }

    public function getMetaDescription(): ?string
    {
        return $this->object['metaDescription'] ?? null;
    }

    public function isNoIndex(): bool
    {
        return $this->object['noIndex'] ?? false;
    }

    public function getOpenGraphTitle(): ?string
    {
        return $this->object['openGraphTitle'] ?? null;
    }

    public function getOpenGraphDescription(): ?string
    {
        return $this->object['openGraphDescription'] ?? null;
    }

    public function getOpenGraphImage(): ?string
    {
        return $this->object['openGraphImage'] ?? null;
    }
}
