<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Article\ArticleTypeCityAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Article\ArticleWithRelatedLists;
use Newland\Toubiz\Api\ObjectAdapter\Article\ArticleWithSocialMediaLinksAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\ArticleAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\AttributeAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\CityAttributes;
use Newland\Toubiz\Api\ObjectAdapter\CategoryAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ExternalIdType;
use Newland\Toubiz\Api\ObjectAdapter\ExternalIdAdapter;
use Newland\Toubiz\Api\ObjectAdapter\ExternalIdAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\FileAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\HasAdditionalExternalIds;
use Newland\Toubiz\Api\ObjectAdapter\HasLanguageGroupingSeparateFromOriginalId;
use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\RelatedListsAdapterInterface;
use Newland\Toubiz\Api\Service\LanguageAware;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\LegacyToubizArticleAdapterCommon;
use Newland\Toubiz\Api\Service\UsesFirstMediumAsMainMedium;
use Newland\Toubiz\Api\Service\WithUuidPredictionService;
use Newland\Toubiz\Api\Service\WithUuidPredictionServiceInterface;
use Newland\Toubiz\Api\Utility\ArrayUtility;
use Newland\Toubiz\Api\Utility\AttributeImportUtility;

class CityAdapter extends AbstractLegacyObjectAdapter implements
    ArticleAdapterInterface,
    ArticleTypeCityAdapterInterface,
    WithUuidPredictionServiceInterface,
    ArticleWithSocialMediaLinksAdapterInterface,
    HasAdditionalExternalIds,
    ArticleWithRelatedLists,
    HasLanguageGroupingSeparateFromOriginalId
{
    use LanguageAware,
        WithUuidPredictionService,
        UsesFirstMediumAsMainMedium,
        LegacyToubizArticleAdapterCommon;

    public function getMainType(): int
    {
        return ArticleConstants::TYPE_CITY;
    }

    public function getMainAddress(): ?AddressAdapterInterface
    {
        return new AddressAdapter($this->object);
    }

    public function getMainCategory(): ?CategoryAdapterInterface
    {
        return null;
    }

    /**
     * @return CategoryAdapterInterface[]
     */
    public function getCategories(): array
    {
        return [];
    }

    /**
     * @return MediumAdapter[]
     */
    public function getMedia(): array
    {
        return $this->extractMediaFromGallery(function (array $data) {
            return new MediumAdapter($data);
        });
    }

    /**
     * @return FileAdapterInterface[]
     */
    public function getFiles(): array
    {
        return [];
    }

    /**
     * @return AttributeAdapterInterface[]
     */
    public function getAttributes(): array
    {
        return AttributeImportUtility::splitAttributeArrayIntoImportables(
            $this->parseAttributes(),
            function ($name, $value) {
                return new AttributeAdapter($this->getExternalId(), $name, $value);
            }
        );
    }

    public function getZipCodes(): array
    {
        $zips = explode(',', $this->object['object']['data_map']['zip_all']['content']);
        return array_map(
            function ($item) {
                return strip_tags((string) $item);
            },
            $zips
        );
    }

    public function getIdToubiz(): string
    {
        $id = $this->object['object']['data_map']['toubiz_id']['content'] ?? '';
        return strip_tags((string) $id);
    }

    public function getIdTomas(): string
    {
        $id = $this->object['object']['data_map']['tomas_id']['content'] ?? '';
        return strip_tags((string) $id);
    }

    public function getClaim(): string
    {
        return $this->stringCleaner
                ->purifyHtml((string) $this->object['object']['data_map']['claim']['content']) ?? '';
    }

    public function getFacts(): string
    {
        return $this->stringCleaner
                ->purifyHtml((string) $this->object['object']['data_map']['facts']['content']) ?? '';
    }

    public function getWebcamUrl(): ?string
    {
        $url = $this->object['object']['data_map']['webcam']['content'] ?? null;
        $url = $url ? strip_tags((string) $url) : null;

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if ($url === null || \strlen($url) <= 8) {
            return null;
        }

        // The protocol may also be missing.
        if (strpos($url, 'http') !== 0) {
            $url = 'http://' . $url;
        }

        return $url;
    }

    public function getWebcamDescription(): ?string
    {
        return $this->stringCleaner
                ->purifyHtml((string) $this->object['object']['data_map']['webcam']['description']) ?? '';
    }

    public function getNews(): ?string
    {
        return $this->stringCleaner
                ->purifyHtml((string) $this->object['object']['data_map']['news']['content']) ?? '';
    }

    public function getBookingUris(): array
    {
        return [];
    }

    public function getDetailUri(): ?string
    {
        return null;
    }

    public function getOpeningTimes(): ?string
    {
        return null;
    }

    public function getOpeningTimesFormat(): ?string
    {
        return null;
    }

    public function getAverageRating(): ?int
    {
        return null;
    }

    public function getNumberOfRatings(): ?int
    {
        return null;
    }

    public function getRelatedLists(): ?RelatedListsAdapterInterface
    {
        $adapter = new RelatedListsAdapter($this->object);
        $adapter->setUuidPredictionService($this->uuidPredictionService);

        return $adapter;
    }

    private function parseAttributes(): array
    {
        $attributes = $this->parseCommonToubizAttributes();

        $childrenList = $this->getChildrenList();
        foreach ($this->extensionAttributeMapping as $extension => $mapping) {
            foreach ($mapping as $normalized => $external) {
                if (!empty($childrenList[$extension]['object']['data_map'][$external]['content'])) {
                    $attributes[$normalized] = $childrenList[$extension]['object']['data_map'][$external]['content'];
                }
            }
        }

        $tagValues = ArrayUtility::trimExplode(',', $this->object['object']['data_map']['tags']['content'] ?? '');
        if (!empty($tagValues)) {
            $attributes[CityAttributes::TAG] = $tagValues;
        }

        return $attributes;
    }

    private function getChildrenList(): array
    {
        $children = [];
        foreach ($this->object['object_children_list'] ?? [] as $child) {
            foreach ($child as $name => $content) {
                $children[$name] = $content;
            }
        }
        return $children;
    }

    /**
     * @var array<string, array<string, string>>
     */
    private $extensionAttributeMapping = [
        'kurort_extension' => [
            CityAttributes::CURE_DESCRIPTION => 'cure_description',
            CityAttributes::CURE_REGION => 'cure_region',
            CityAttributes::CURE_ALTITUDE => 'cure_lage',
            CityAttributes::CURE_CLIMATE => 'cure_klima',
            CityAttributes::CURE_AILMENTS_TAG => 'cure_heilanzeigen_tag',
            CityAttributes::CURE_AILMENTS => 'cure_heilanzeigen',
            CityAttributes::CURE_CURES => 'cure_heilmittel',
            CityAttributes::CURE_SCREENING => 'cure_vorsorge',
            CityAttributes::CURE_COMPACT_CURE => 'cure_kompaktkur',
            CityAttributes::CURE_THERAPY => 'cure_therapie',
            CityAttributes::CURE_BATHS => 'cure_baeder',
            CityAttributes::CURE_MASSAGE => 'cure_massage',
            CityAttributes::CURE_WHOLESOME => 'cure_ganzheitlich',
            CityAttributes::CURE_VARIOUS => 'cure_sonstiges',
            CityAttributes::CURE_LABEL => 'cure_praedikat',
        ],
    ];
}
