<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\TourApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\ArticleListAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\RelatedListsAdapterInterface;
use Newland\Toubiz\Api\Service\WithUuidPredictionService;
use Newland\Toubiz\Api\Utility\ArrayUtility;

class RelatedListsAdapter implements RelatedListsAdapterInterface
{
    use WithUuidPredictionService;

    /**
     * @var array
     */
    protected $object;

    public function __construct(array $object)
    {
        $this->object = $object;
    }

    public function getHighlightsList(): ?ArticleListAdapterInterface
    {
        $articleIdentifiers = ArrayUtility::emptyExplode(
            '#',
            $this->object['object']['data_map']['poi_highlights']['remote_ids'] ?? ''
        );

        return $this->getArticleListData('', $articleIdentifiers);
    }

    public function getArticleLists(): array
    {
        $lists = [];
        $index = 1;

        while ($this->hasRelatedListWithIndex((string) $index)) {
            $title = $this->object['object']['data_map']['list_' . $index . '_name']['content'] ?? '';

            $articleIds = ArrayUtility::emptyExplode(
                '#',
                $this->object['object']['data_map']['list_' . $index . '_highlights']['remote_ids'] ?? ''
            );

            $categoryIds = ArrayUtility::emptyExplode(
                '#',
                $this->object['object']['data_map']['list_' . $index . '_cats']['remote_ids'] ?? ''
            );

            $articleList = $this->getArticleListData(
                $title,
                $articleIds,
                $categoryIds
            );

            if ($articleList->hasItems()) {
                $lists[] = $articleList;
            }

            $index++;
        }

        return $lists;
    }

    private function getArticleListData(
        string $title = '',
        array $articleIdentifiers = [],
        array $categoryIdentifiers = []
    ): ArticleListAdapter {
        $adapter = new ArticleListAdapter(
            $title,
            $articleIdentifiers,
            $categoryIdentifiers
        );

        $adapter->setUuidPredictionService($this->uuidPredictionService);

        return $adapter;
    }

    private function hasRelatedListWithIndex(string $index): bool
    {
        return array_key_exists('list_' . $index . '_name', $this->object['object']['data_map'])
            && array_key_exists('list_' . $index . '_cats', $this->object['object']['data_map'])
            && array_key_exists('list_' . $index . '_highlights', $this->object['object']['data_map']);
    }
}
