<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Exception;

class StringCleaningException extends \Exception
{

    /** @var string */
    protected $dumpLocation;

    public function __construct(string $dumpLocation, string $message, int $code, \Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->dumpLocation = $dumpLocation;
    }

    public function getDumpLocation(): string
    {
        return $this->dumpLocation;
    }

    public static function create(string $triggeringString, \Throwable $previous = null): self
    {
        $dumpDir = sys_get_temp_dir();
        if (\defined('FLOW_PATH_DATA')) {
            $dumpDir = (string) FLOW_PATH_DATA;
        }

        $dumpLocation = sprintf('%s/StringCleaner.%s.txt', $dumpDir, md5($triggeringString));
        file_put_contents($dumpLocation, $triggeringString);

        if (\strlen($triggeringString) > 200) {
            $presentationString = sprintf(
                '%s ... %s',
                substr($triggeringString, 0, 100),
                substr($triggeringString, -100)
            );
        } else {
            $presentationString = $triggeringString;
        }

        $message = sprintf(
            'String "%s" could not be cleaned - It most likely contains invalid UTF-8 codepoints.'
            . ' The raw string was dumped in `%s` for later debugging purposes',
            $presentationString,
            $dumpLocation
        );
        return new static($dumpLocation, $message, $previous ? $previous->getCode() : 500, $previous);
    }
}
