<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\Brochure\Parser;

/**
 * Parser that parses URIs such as the following into key/values arrays.
 * /(key1)/value1/(key2)/value2/(key3)/value3
 */
class UriPathBracketBasedParser
{

    public function parse(string $uri): array
    {
        $array = [];
        $currentKey = null;
        $parts = explode('/', $uri);

        foreach ($parts as $part) {
            preg_match('/\\((.*)\\)/', $part, $matches);
            $key = $matches[1] ?? null;
            if ($key !== null) {
                $currentKey = $key;
            } elseif ($currentKey !== null) {
                $array[$currentKey] = $part;
                $currentKey = null;
            }
        }

        return $array;
    }
}
